import { world, system } from '@minecraft/server'
import { Adult, Baby, Item, SpawnEgg } from '../item/Hamster.js'
import { getColor, getHamsterItemData } from '../entity/Hamster'
import { Helper } from "../utils/Helper.js"
function tagRider(entity) {
	const rider = getRider(entity)
	if (rider == null) return
	rider.setProperty('sf_nba:interaction_state', 'wheel')
	rider.triggerEvent('sf_nba:is_riding_wheel')
}
function getRider(entity) {
	const rideableComponent = entity.getComponent('rideable')
	if (rideableComponent == null) return
	return rideableComponent.getRiders()[0]
}
function rideWheel(target, hamster) {
	system.runTimeout(() => {
		const rideableComponent = target.getComponent('rideable')
		if (rideableComponent != null) {
			rideableComponent.addRider(hamster)
			world.playSound('sf_hba.furniture.wheel.enterleave', hamster.location)
		}
	}, 1)
}
class HamsterWheel {
	constructor() {
		this.init()
	}
	init() {
		world.beforeEvents.playerInteractWithEntity.subscribe(this.interact.bind(this))
	}
	interact(e) {
		const { target, itemStack, player } = e
		if (!(target.typeId == 'sf_hba:hamster_wheel' || target.typeId == 'sf_nba:hamster_wheel')) return
		if (itemStack?.typeId == 'sf_nba:whistle') return
		if (itemStack?.typeId == 'sf_hba:whistle') return
		if (![...Adult, ...Baby, ...Item, ...SpawnEgg].includes(itemStack?.typeId)) return
		system.run(() => {
			const data = getHamsterItemData(itemStack)
			const hamster = player.dimension.spawnEntity('sf_nba:hamster', target.location)
			const tameComponent = hamster.getComponent('tameable')
			world.playSound("sf_hba.furniture.wheel.enterleave", target.location)
			Helper.decreaseMainhandItemStack(player, 1, itemStack)
			tagRider(target)
			hamster.triggerEvent(`sf_nba:set_variant_${getColor(itemStack.typeId)}`)
			hamster.triggerEvent(`sf_nba:set_pattern_blank`)
			rideWheel(target, hamster)
			if ([...Adult, ...Baby, ...Item].includes(itemStack.typeId)) {
				tameComponent.tame(player)
				hamster.triggerEvent('sf_nba:on_tame')
				hamster.setProperty('sf_nba:is_following_owner', data.isFollowingOwner)
				hamster.setProperty('sf_nba:dye', data.color)
				hamster.setDynamicProperty('sf_nba:calories', data.calories)
				hamster.setDynamicProperty('sf_nba:owner_id', player.id)
				hamster.setProperty(`sf_nba:overfeed_level`, data.overfeedLevel)
				if (data.overfeedLevel > 0) {
					for (let i = 0; i < data.overfeedLevel; i += 1) {
						hamster.setDynamicProperty(`sf_nba:overfeed_item_${i + 1}`, itemStack.getDynamicProperty(`sf_nba:overfeed_item_${i + 1}`));
					}
				}
				if (data.isBaby) {
					hamster.triggerEvent('sf_nba:set_baby')
				} else {
					hamster.triggerEvent('sf_nba:set_adult')
				}
				if (data.accessory != null) hamster.setProperty('sf_nba:equipped_accessory', data.accessory)
				if (data.name) hamster.nameTag = data.name
			}
		})
	}
}
new HamsterWheel()